/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.report.result;

import cz.insophy.inplan.report.ReportUtilities;
import cz.insophy.inplan.shop.CapabilityIsland;
import cz.insophy.inplan.util.EventContainer;
import java.io.Serializable;
import javax.annotation.Nonnull;

public class CapacityUsageTableRow
implements Comparable<CapacityUsageTableRow>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final CapabilityIsland island;
    private final EventContainer events;

    public CapacityUsageTableRow(CapabilityIsland island, EventContainer events) {
        this.island = island;
        this.events = events;
    }

    public CapabilityIsland getIsland() {
        return this.island;
    }

    public EventContainer getEvents() {
        return this.events;
    }

    public long getCapacityUsed() {
        return Math.round(this.events.getMinusSum());
    }

    public long getCapacityUnused() {
        return this.getCapacityFree() - this.getCapacityUsed();
    }

    public long getCapacityFree() {
        return Math.round(this.events.getPlusSum());
    }

    public double getCapacityUsedRelative() {
        double nom = this.getCapacityUsed();
        double denom = this.getCapacityFree();
        return ReportUtilities.getSafeRatio(nom, denom);
    }

    @Override
    public int compareTo(@Nonnull CapacityUsageTableRow o) {
        return this.island.getName().compareTo(o.island.getName());
    }

    public String toString() {
        return "CapacityUsageTableRow [island=" + this.island.getName() + ", events=" + this.events + "]";
    }
}

